package gov.va.med.domain.model;



/**
 * Statuspayload
 * Data Transfer Object for HL7 messaging status.
 * 
 *
 * @author Slava Uchitel
 * @version $Id: StatusPayload.java,v 1.1.1.1 2005/05/13 19:40:37 jon.crater Exp $
 * @since MHV 2.0 <br>03/15/2005
 */
public class StatusPayload extends HL7Error implements IPayload
{   
    private static final long serialVersionUID = 3545802065571100728L;
    private int _status;
    private String _statusDescription;
    
    public StatusPayload(int status)
    {
        _status=status;
        _statusDescription = getErrorDescriptionFromStatus(_status);
    }
    
    public StatusPayload(String statusDescription)
    {
        _statusDescription = statusDescription;
        _status = StatusPayload.getErrorStatusFromDescription(statusDescription);
    }
    
    public int getStatus()
    {
        return _status;
    }
    
    public String getStatusDescription()
    {
        return _statusDescription;
    }
} 
